﻿using VA.TMP.Integration.VIMT.HealthShare.Mappers;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Messages.HealthShare;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelOutbound
{
    /// <summary>
    /// Map Appointment step.
    /// </summary>
    public class MapAppointmentStep : FilterBase<MakeCancelOutboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelOutboundStateObject state)
        {
            foreach (var patient in state.RequestMessage.Patients)
            {
                var ecRequestMessage = new MakeCancelOutboundEcRequestMapper(state, patient).Map();

                state.EcRequestMessages.Add(ecRequestMessage);
                state.ResponseMessage.PatientIntegrationResultInformation.Add(new PatientIntegrationResultInformation {ControlId = ecRequestMessage.ControlId, PatientId = patient});
            }
        }
    }
}